﻿CREATE TABLE [PanelMgmt].[PMMasterLabIndex] (
    [LabChemTestSID]       INT           NOT NULL,
    [Sta3n]                SMALLINT      NOT NULL,
    [LabChemTestName]      VARCHAR (50)  NULL,
    [ResultForTestNumeric] INT           NOT NULL,
    [DateExtracted]        DATETIME      NOT NULL,
    [TestGroup]            VARCHAR (100) NULL,
    [LOINC]                VARCHAR (50)  NULL,
    [WorkLoadCode]         VARCHAR (50)  NULL
);


GO
CREATE CLUSTERED INDEX [CL_PMMasterLabIndex_LabChemTestSID_TestGroup]
    ON [PanelMgmt].[PMMasterLabIndex]([LabChemTestSID] ASC, [TestGroup] ASC) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);


GO
CREATE NONCLUSTERED INDEX [PMMasterLabIndex_TestGroup_LabChemTestName_Sta3n]
    ON [PanelMgmt].[PMMasterLabIndex]([TestGroup] ASC, [LabChemTestName] ASC, [Sta3n] ASC) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);

